/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.placement;

import biomesoplenty.util.worldgen.BOPPlacementUtils;
import biomesoplenty.worldgen.feature.BOPCaveFeatures;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;

public class BOPCavePlacements {
    public static final ResourceKey<PlacedFeature> GLOWING_GROTTO_VEGETATION = BOPPlacementUtils.createKey("glowing_grotto_vegetation");
    public static final ResourceKey<PlacedFeature> GLOWING_GROTTO_MUD = BOPPlacementUtils.createKey("glowing_grotto_mud");
    public static final ResourceKey<PlacedFeature> GLOWWORM_SILK_STRANDS = BOPPlacementUtils.createKey("glowworm_silk_strands");
    public static final ResourceKey<PlacedFeature> GIANT_GLOWSHROOM_CAVE = BOPPlacementUtils.createKey("giant_glowshroom_cave");
    public static final ResourceKey<PlacedFeature> HUGE_GLOWSHROOM_CAVE = BOPPlacementUtils.createKey("huge_glowshroom_cave");
    public static final ResourceKey<PlacedFeature> MEDIUM_GLOWSHROOM_CAVE = BOPPlacementUtils.createKey("medium_glowshroom_cave");
    public static final ResourceKey<PlacedFeature> SMALL_GLOWSHROOM_CAVE = BOPPlacementUtils.createKey("small_glowshroom_cave");
    public static final ResourceKey<PlacedFeature> EXTRA_GLOW_LICHEN = BOPPlacementUtils.createKey("extra_glow_lichen");
    public static final ResourceKey<PlacedFeature> HANGING_COBWEBS = BOPPlacementUtils.createKey("hanging_cobwebs");
    public static final ResourceKey<PlacedFeature> CORNER_COBWEBS = BOPPlacementUtils.createKey("corner_cobwebs");
    public static final ResourceKey<PlacedFeature> SPIDER_EGGS = BOPPlacementUtils.createKey("spider_eggs");
    public static final ResourceKey<PlacedFeature> STRINGY_COBWEB = BOPPlacementUtils.createKey("stringy_cobweb");
    public static final ResourceKey<PlacedFeature> WEBBING = BOPPlacementUtils.createKey("webbing");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatureGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference WEBBING = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.WEBBING);
        Holder.Reference STRINGY_COBWEB = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.STRINGY_COBWEB);
        Holder.Reference SPIDER_EGG = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.SPIDER_EGG);
        Holder.Reference CORNER_COBWEBS = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.CORNER_COBWEBS);
        Holder.Reference HANGING_COBWEB = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.HANGING_COBWEB);
        Holder.Reference EXTRA_GLOW_LICHEN = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.EXTRA_GLOW_LICHEN);
        Holder.Reference SMALL_GLOWSHROOM_CAVE = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.SMALL_GLOWSHROOM_CAVE);
        Holder.Reference MEDIUM_GLOWSHROOM_CAVE = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.MEDIUM_GLOWSHROOM_CAVE);
        Holder.Reference HUGE_GLOWSHROOM_CAVE = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.HUGE_GLOWSHROOM_CAVE);
        Holder.Reference GIANT_GLOWSHROOM_CAVE = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.GIANT_GLOWSHROOM_CAVE);
        Holder.Reference GLOWWORM_SILK = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.GLOWWORM_SILK);
        Holder.Reference MUD_PATCH = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.MUD_PATCH);
        Holder.Reference GLOWING_MOSS_PATCH = configuredFeatureGetter.getOrThrow(BOPCaveFeatures.GLOWING_MOSS_PATCH);
        BOPCavePlacements.register(context, GLOWING_GROTTO_VEGETATION, GLOWING_MOSS_PATCH, List.of(CountPlacement.of((int)16), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, GLOWING_GROTTO_MUD, MUD_PATCH, List.of(CountPlacement.of((int)24), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, GLOWWORM_SILK_STRANDS, GLOWWORM_SILK, List.of(CountPlacement.of((int)150), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, BOPCavePlacements.GIANT_GLOWSHROOM_CAVE, GIANT_GLOWSHROOM_CAVE, List.of(CountPlacement.of((int)50), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, BOPCavePlacements.HUGE_GLOWSHROOM_CAVE, HUGE_GLOWSHROOM_CAVE, List.of(CountPlacement.of((int)75), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, BOPCavePlacements.MEDIUM_GLOWSHROOM_CAVE, MEDIUM_GLOWSHROOM_CAVE, List.of(CountPlacement.of((int)100), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, BOPCavePlacements.SMALL_GLOWSHROOM_CAVE, SMALL_GLOWSHROOM_CAVE, List.of(CountPlacement.of((int)125), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, BOPCavePlacements.EXTRA_GLOW_LICHEN, EXTRA_GLOW_LICHEN, List.of(CountPlacement.of((int)25), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()));
        BOPCavePlacements.register(context, HANGING_COBWEBS, HANGING_COBWEB, List.of(CountPlacement.of((int)200), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.hasSturdyFace((Direction)Direction.DOWN), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, BOPCavePlacements.CORNER_COBWEBS, CORNER_COBWEBS, List.of(CountPlacement.of((int)50), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)24), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, SPIDER_EGGS, SPIDER_EGG, List.of(CountPlacement.of((int)35), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, BOPCavePlacements.STRINGY_COBWEB, STRINGY_COBWEB, List.of(CountPlacement.of((int)250), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()));
        BOPCavePlacements.register(context, BOPCavePlacements.WEBBING, WEBBING, List.of(CountPlacement.of((int)20), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()));
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> placedFeatureKey, Holder<ConfiguredFeature<?, ?>> configuredFeature, PlacementModifier ... modifiers) {
        BOPCavePlacements.register(context, placedFeatureKey, configuredFeature, List.of(modifiers));
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> placedFeatureKey, Holder<ConfiguredFeature<?, ?>> configuredFeature, List<PlacementModifier> modifiers) {
        context.register(placedFeatureKey, (Object)new PlacedFeature(configuredFeature, modifiers));
    }
}

